--SETTINGS
PAK_NAME = "Simple Tree Restoration.pak"
FINAL_MODEL_NAME = "MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN" --Must end on .SCENE.MBIN
MODEL_LIST = {-- All entries must have all three keys ("ID","PATH,"SCALE"). "ID" can be any string as long as it does not repeat.
	{
		["PATH"] = "MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF_VANILLA.SCENE.MBIN",
		["SCALE"] = 1,
	},
	{
		["PATH"] = "MODELS/PLANETS/BIOMES/COMMON/TREES/MEDIUMTREE1.SCENE.MBIN",
		["SCALE"] = 1.5,
	},
}

--Don't touch this probably
function generate_scene(FINAL_MODEL_NAME,MODEL_LIST)
  text_table = {}
  --Add the scene header
  table.insert(text_table,[[<?xml version="1.0" encoding="utf-8"?>
<!--File created using MBINCompiler version (3.42.0)-->
<Data template="TkSceneNodeData">
  <Property name="Name" value="]]..string.gsub(FINAL_MODEL_NAME,".SCENE.MBIN","")..[[" />
  <Property name="NameHash" value="0" />
  <Property name="Type" value="MODEL" />
  <Property name="Transform" value="TkTransformData.xml">
    <Property name="TransX" value="0" />
    <Property name="TransY" value="0" />
    <Property name="TransZ" value="0" />
    <Property name="RotX" value="0" />
    <Property name="RotY" value="0" />
    <Property name="RotZ" value="0" />
    <Property name="ScaleX" value="1" />
    <Property name="ScaleY" value="1" />
    <Property name="ScaleZ" value="1" />
  </Property>
  <Property name="Attributes">
    <Property value="TkSceneNodeAttributeData.xml">
      <Property name="Name" value="NUMLODS" />
      <Property name="AltID" value="" />
      <Property name="Value" value="1" />
    </Property>
  </Property>
  <Property name="Children">
]])
  --Add a child reference for every model in the list
  TYPE_ID = "_"..string.match(FINAL_MODEL_NAME,"/(%a+).SCENE").."_"
  for i, option in ipairs(MODEL_LIST) do
  table.insert(text_table,[[    <Property value="TkSceneNodeData.xml">
      <Property name="Name" value="]]..TYPE_ID..i..[[" />
      <Property name="NameHash" value="0" />
      <Property name="Type" value="REFERENCE" />
      <Property name="Transform" value="TkTransformData.xml">
        <Property name="TransX" value="0" />
        <Property name="TransY" value="0" />
        <Property name="TransZ" value="0" />
        <Property name="RotX" value="0" />
        <Property name="RotY" value="0" />
        <Property name="RotZ" value="0" />
        <Property name="ScaleX" value="]]..option["SCALE"]..[[" />
        <Property name="ScaleY" value="]]..option["SCALE"]..[[" />
        <Property name="ScaleZ" value="]]..option["SCALE"]..[[" />
      </Property>
      <Property name="Attributes">
        <Property value="TkSceneNodeAttributeData.xml">
          <Property name="Name" value="SCENEGRAPH" />
          <Property name="AltID" value="" />
          <Property name="Value" value="]]..option["PATH"]..[[" />
        </Property>
      </Property>
      <Property name="Children" />
    </Property>
]])
	end
  --Add the scene footer
  table.insert(text_table,[[  </Property>
</Data>]])
  return table.concat(text_table)
end

function generate_descriptor_file(FINAL_MODEL_NAME,MODEL_LIST)
	TYPE_ID = "_"..string.match(FINAL_MODEL_NAME,"/(%a+).SCENE").."_"
	
	text_table = {}
	--Insert the header of the descriptor
	table.insert(text_table,[[<?xml version="1.0" encoding="utf-8"?>
<!--File created using MBINCompiler version (3.42.0)-->
<Data template="TkModelDescriptorList">
  <Property name="List">
    <Property value="TkResourceDescriptorList.xml">
      <Property name="TypeId" value="]]..TYPE_ID..[[" />
      <Property name="Descriptors">
]])
	
	--Insert each descriptor option  
	for i, option in ipairs(MODEL_LIST) do
		table.insert(text_table,[[        <Property value="TkResourceDescriptorData.xml">
          <Property name="Id" value="]]..TYPE_ID..i..[[" />
          <Property name="Name" value="]]..TYPE_ID..i..[[" />
          <Property name="ReferencePaths">
            <Property value="NMSString0x80.xml">
              <Property name="Value" value="]]..option["PATH"]..[[" />
            </Property>
          </Property>
          <Property name="Chance" value="0" />
          <Property name="Children" />
        </Property>
]])
	end
  --Insert the footer of the descriptor
  table.insert(text_table,[[      </Property>
    </Property>
  </Property>
</Data>]])
  return table.concat(text_table)
end

NMS_MOD_DEFINITION_CONTAINER = 
{
	["MOD_FILENAME"] 			= PAK_NAME,
	["MOD_DESCRIPTION"]		= "",
	["MOD_AUTHOR"]				= "",
	["NMS_VERSION"]				= "",
	["ADD_FILES"] 			= 
	{
		{--Create scene
			["FILE_DESTINATION"] = string.gsub(FINAL_MODEL_NAME,".SCENE.MBIN",".SCENE.EXML"),
			["FILE_CONTENT"] = generate_scene(FINAL_MODEL_NAME,MODEL_LIST)
		},
		{--Create descriptor
			["FILE_DESTINATION"] = string.gsub(FINAL_MODEL_NAME,".SCENE.MBIN",".DESCRIPTOR.EXML"),
			["FILE_CONTENT"] = generate_descriptor_file(FINAL_MODEL_NAME,MODEL_LIST)
		},
	},
	["MODIFICATIONS"] 		=             --REQUIRED SECTION
	{
		{
			["MBIN_CHANGE_TABLE"] = 
			{ 
				{--Copy the vanilla model somewhere else so we can still use it
					["MBIN_FILE_SOURCE"] 	= {
						{"MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.SCENE.MBIN","MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF_VANILLA.SCENE.MBIN"},
						{"MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF.DESCRIPTOR.MBIN","MODELS/PLANETS/BIOMES/HQLUSH/HQTREES/HQTREEREF_VANILLA.DESCRIPTOR.MBIN"},
						},
				},
			}
		},
	}
}
--NOTE: ANYTHING NOT in table NMS_MOD_DEFINITION_CONTAINER IS IGNORED AFTER THE SCRIPT IS LOADED
--IT IS BETTER TO ADD THINGS AT THE TOP IF YOU NEED TO
--DON'T ADD ANYTHING PASS THIS POINT HERE

